//
//  OPAppStore.h
//  ApplicationFrameworks
//
//  Created by Roustem Karimov on 2014-07-30.
//
//

#import <Foundation/Foundation.h>
#import "OPApplicationCustomer.h"

FOUNDATION_EXPORT NSString *const OPPremiumMobileProductIdentifier;
FOUNDATION_EXPORT NSString *const OPPremiumDesktopProductIdentifier;

FOUNDATION_EXPORT NSString *const OPIndividualAnnualSubscriptionProductIdentifier;
FOUNDATION_EXPORT NSString *const OPFamilyAnnualSubscriptionProductIdentifier;

FOUNDATION_EXPORT NSString *const OPAppStoreCannotMakePaymentsNotification;
FOUNDATION_EXPORT NSString *const OPAppStoreFailedToLoadProductInformationFromAppStoreNotification;
FOUNDATION_EXPORT NSString *const OPAppStoreCompletedPurchaseNotification;
FOUNDATION_EXPORT NSString *const OPAppStoreLoadedProductInformationFromAppStoreNotification;
FOUNDATION_EXPORT NSString *const OPAppStoreReceivedFreshApplicationReceiptNotification;
FOUNDATION_EXPORT NSString *const OPAppStoreNotificationCompletedPurchaseSuccessfullyKey;
FOUNDATION_EXPORT NSString *const OPAppStoreNotificationErrorKey;

@class OPAppStore;
@class OPAppStoreProduct;

@interface OPAppStore : NSObject

@property (nonatomic, readonly) NSString *appBundleIdentifier;
@property (nonatomic, readonly) NSString *appBundleVersion;
@property (nonatomic, readonly) BOOL useAppleStore;

@property (nonatomic, readonly) BOOL canPurchase;
@property (nonatomic, readonly, getter=isPurchased) BOOL purchased;
@property (nonatomic, readonly, getter=isPurchasingOrRestoring) BOOL purchasingOrRestoring;

- (instancetype)initWithAppBundleIdentifier:(NSString *)appBundleIdentifier appBundleVersion:(NSString *)appBundleVersion useAppleStore:(BOOL)useAppleStore;

- (void)refreshProducts;

- (void)refreshApplicationReceipt;
- (void)startRestoringPurchases;
- (void)performPurchaseOfProduct:(OPAppStoreProduct *)product forViewController:(id)viewController;

- (OPAppStoreProduct *)appStoreProductForIdentifier:(NSString *)productIdentifier;

- (void)readApplicationReceiptIfNeeded;

@end
